package donnee;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import controleur.Journal;
import modele.Exoplanete;

public class ExoplaneteDAO implements ExoplaneteSQL {

	public ExoplaneteDAO()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "new ExoplaneteDAO()");
	}
	
	public List<Exoplanete> listerExoplanetes()
	{
		Journal.ecrire(Journal.NIVEAU.ROULEMENT, "ExoplaneteDAO.listerExoplanetes()");
		List<Exoplanete> listeExoplanetes =  new ArrayList<Exoplanete>();			
		Connection connexion = BaseDeDonnees.getInstance().getConnection();
		if(connexion == null) return listeExoplanetes;
		
		Statement requeteListeExoplanetes;
		try {
			requeteListeExoplanetes = connexion.createStatement();
			ResultSet curseurListeExoplanetes = requeteListeExoplanetes.executeQuery(SQL_LISTER_EXOPLANETES);
			while(curseurListeExoplanetes.next())
			{
				int id = curseurListeExoplanetes.getInt("id");
				String nom = curseurListeExoplanetes.getString("planete");
				String etoile = curseurListeExoplanetes.getString("etoile");
				String masse = curseurListeExoplanetes.getString("masse");
				String rayon = curseurListeExoplanetes.getString("rayon");
				String flux = curseurListeExoplanetes.getString("flux");
				String temperature = curseurListeExoplanetes.getString("temperature");
				String periode = curseurListeExoplanetes.getString("periode");
				String distance = curseurListeExoplanetes.getString("distance");
				
				Exoplanete exoplanete = new Exoplanete();
				exoplanete.setId(id);
				exoplanete.setNom(nom);
				exoplanete.setEtoile(etoile);
				exoplanete.setMasse(masse);
				exoplanete.setRayon(rayon);
				exoplanete.setFlux(flux);
				exoplanete.setTemperature(temperature);
				exoplanete.setPeriode(periode);
				exoplanete.setDistance(distance);
				
				listeExoplanetes.add(exoplanete);
			}
		} catch (SQLException e) {
				e.printStackTrace();
		}
		
		return listeExoplanetes;
	}
	
	public void ajouterExoplanete(Exoplanete exoplanete)
	{		
		Journal.ecrire(Journal.NIVEAU.ROULEMENT, "ExoplaneteDAO.ajouterExoplanete()");
		Connection connexion = BaseDeDonnees.getInstance().getConnection();
		try {
			PreparedStatement requeteAjouterExoplanete;
			requeteAjouterExoplanete = connexion.prepareStatement(SQL_AJOUTER_EXOPLANETE);
			requeteAjouterExoplanete.setString(1, exoplanete.getNom());
			requeteAjouterExoplanete.setString(2, exoplanete.getEtoile());
			requeteAjouterExoplanete.setString(3, exoplanete.getMasse());
			requeteAjouterExoplanete.setString(4, exoplanete.getRayon());
			requeteAjouterExoplanete.setString(5, exoplanete.getFlux());
			requeteAjouterExoplanete.setString(6, exoplanete.getTemperature());
			requeteAjouterExoplanete.setString(7, exoplanete.getPeriode());
			requeteAjouterExoplanete.setString(8, exoplanete.getDistance());
			
			requeteAjouterExoplanete.execute();
		} catch (SQLException e) {
				e.printStackTrace();
		}
	}
	
	public void editerExoplanete(Exoplanete exoplanete)
	{		
		Journal.ecrire(Journal.NIVEAU.ROULEMENT, "ExoplaneteDAO.editerExoplanete()");
		System.out.println("editer " + exoplanete.getNom());
		Connection connexion = BaseDeDonnees.getInstance().getConnection();
		try {
			PreparedStatement requeteEditerExoplanete;
			requeteEditerExoplanete = connexion.prepareStatement(SQL_EDITER_EXOPLANETE);
			requeteEditerExoplanete.setString(1, exoplanete.getNom());
			requeteEditerExoplanete.setString(2, exoplanete.getEtoile());
			requeteEditerExoplanete.setString(3, exoplanete.getMasse());
			requeteEditerExoplanete.setString(4, exoplanete.getRayon());
			requeteEditerExoplanete.setString(5, exoplanete.getFlux());
			requeteEditerExoplanete.setString(6, exoplanete.getTemperature());
			requeteEditerExoplanete.setString(7, exoplanete.getPeriode());
			requeteEditerExoplanete.setString(8, exoplanete.getDistance());
			requeteEditerExoplanete.setInt(9, exoplanete.getId());
			
			requeteEditerExoplanete.execute();
		} catch (SQLException e) {
				e.printStackTrace();
		}
	}
	public void effacerExoplanete(Exoplanete exoplanete)
	{		
		Journal.ecrire(Journal.NIVEAU.ROULEMENT, "ExoplaneteDAO.effacerExoplanete()");
		Connection connexion = BaseDeDonnees.getInstance().getConnection();
		try {
			PreparedStatement requeteEffacerExoplanete;
			requeteEffacerExoplanete = connexion.prepareStatement(SQL_EFFACER_EXOPLANETE);
			requeteEffacerExoplanete.setInt(1, exoplanete.getId());
			requeteEffacerExoplanete.execute();
		} catch (SQLException e) {
				e.printStackTrace();
		}
	}	
}
