package vue;

import architecture.Vue;
import controleur.ControleurExoplanetes;
import controleur.Journal;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import modele.Exoplanete;

public class VueAjouter extends Vue {

	protected ControleurExoplanetes controleur;
	protected static VueAjouter instance = null; 
	public static VueAjouter getInstance() {if(null==instance)instance = new VueAjouter();return VueAjouter.instance;}; 
	
	private VueAjouter() 
	{
		super("vue-ajouter.fxml", VueAjouter.class,1300,800); 
		super.controleur = this.controleur = new ControleurExoplanetes();
		Journal.ecrire(Journal.NIVEAU.DETAIL, "new VueAjouter()");		
	}
		
	public void activerControles()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "VueAjouter.activerControles()");
		super.activerControles();
		
		Button actionEnregistrer = (Button) lookup("#action-enregistrer");
		actionEnregistrer.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent e) {
				System.out.println("Action Enregistrer");
				controleur.notifierEnregistrerAjout();
			}}			
		);
	}
	
	public Exoplanete lireExoplaneteEntree()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "VueAjouter.lireExoplaneteEntree()");
		Exoplanete exoplanete = new Exoplanete();
		
		TextField champsNom = (TextField) lookup("#champs-nom");
		TextField champsEtoile = (TextField) lookup("#champs-etoile");
		TextField champsMasse = (TextField) lookup("#champs-masse");
		TextField champsRayon = (TextField) lookup("#champs-rayon");
		TextField champsFlux = (TextField) lookup("#champs-flux");		
		TextField champsTemperature = (TextField) lookup("#champs-temperature");
		TextField champsPeriode = (TextField) lookup("#champs-periode");
		TextField champsDistance = (TextField) lookup("#champs-distance");
		
		exoplanete.setNom(champsNom.getText());
		exoplanete.setEtoile(champsEtoile.getText());
		exoplanete.setMasse(champsMasse.getText());
		exoplanete.setRayon(champsRayon.getText());
		exoplanete.setFlux(champsFlux.getText());
		exoplanete.setTemperature(champsTemperature.getText());
		exoplanete.setPeriode(champsPeriode.getText());
		exoplanete.setDistance(champsDistance.getText());
		
		return exoplanete;
	}
	
}
