package vue;

import architecture.Vue;
import controleur.ControleurExoplanetes;
import controleur.Journal;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import modele.Exoplanete;

public class VueEffacer extends Vue implements Messages{

	protected Exoplanete exoplanete = null;
	protected ControleurExoplanetes controleur;
	protected static VueEffacer instance = null; 
	public static VueEffacer getInstance() {if(null==instance)instance = new VueEffacer();return VueEffacer.instance;}; 
	
	private VueEffacer() 
	{
		super("vue-effacer.fxml", VueEffacer.class,1300,800); 
		super.controleur = this.controleur = new ControleurExoplanetes();
		Journal.ecrire(Journal.NIVEAU.DETAIL, "new VueEffacer()");
	}
		
	public void activerControles()
	{
		Journal.ecrire(Journal.NIVEAU.DETAIL, "VueEffacer.activerControles()");
		super.activerControles();
		
		Button actionEffacerOui = (Button) lookup("#action-effacer-oui");
		actionEffacerOui.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent e) {
				System.out.println("Action Effacer OUI");
				controleur.notifierActionEffacerPourExoplanete(exoplanete, true);
			}}			
		);
		
		Button actionEffacerNon = (Button) lookup("#action-effacer-non");
		actionEffacerNon.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent e) {
				System.out.println("Action Effacer NON");
				controleur.notifierActionEffacerPourExoplanete(exoplanete, false);
			}}			
		);
		
	}
		
	public Exoplanete lireExoplaneteEntree()
	{		
		Journal.ecrire(Journal.NIVEAU.DETAIL, "VueEffacer.lireExoplaneteEntree()");
		return exoplanete;
	}
	
	public void afficherExoplanete(Exoplanete exoplanete)
	{
		Journal.ecrire(Journal.NIVEAU.NOTIFICATION, "VueEffacer.afficherExoplanete()");
		this.exoplanete = exoplanete;
		Label question = (Label) lookup("#question-effacer");
		String questionEtVariables = QUESTION_EFFACER.replace("%nom%", exoplanete.getNom());
		question.setText(questionEtVariables);
	}
}
